# -*- coding: utf-8 -*-
from math import *
import numpy as np
import matplotlib.pyplot as plt
import csv

##############################
## RECUPERATION DES DONNEES ##
##############################

Te=0.001 #période d'échatillonage en s
nom_fichier = "MESURES_UHING.csv" 
path="CHEMIN DU DOSSIER AVEC DES \\ AU LIEU DES \ et finir par des \\ " # CHEMIN DU DOSSIER AVEC DES \\ au lieu des \ et finir par des \\ 
l_temps_brute, l_vitesse_consigne_brute, l_vitesse_moteur_brute, l_vitesse_lineaire_brute, l_courant_brute, l_angle_brute, l_vitesse_lineaire_calculee_brute, l_vitesse_glissement_brute, l_deplacement_brute, l_pas_brute = [], [], [], [], [], [] , [], [], [], []  # Temps (s)	Consigne (tr/min)	Vitesse du moteur (tr/min)	Vitesse lineaire (mm/s)	Courant (A)	Angle (deg)	Vitesse lineaire calculee (mm/s)	Vitesse de glissement (mm/s)	Deplacement (mm)	Pas (mm)
t_i, t_f = 0, 3.1 #Bornes inférieur et supérieur du temps. 

with open(path+nom_fichier, 'r') as f:
    reader = csv.reader(f, delimiter=';')  # <--- attention au delimiter
    # Sauter les 13 premières lignes qui correspondent au descriptif de l'essai
    for _ in range(13):
        next(reader)
        
    for row in reader:
        k = 0
        for val in row:
            if k == 0:
                l_temps_brute.append(float(val))
            elif k == 1:
                l_vitesse_consigne_brute.append(float(val))
            elif k == 2:
                l_vitesse_moteur_brute.append(float(val))
            elif k == 3:
                l_vitesse_lineaire_brute.append(float(val))
            elif k == 4:
                l_courant_brute.append(float(val))
            elif k == 5:
                l_angle_brute.append(float(val))
            elif k == 6:
                l_vitesse_lineaire_calculee_brute.append(float(val))
            elif k == 7:
                l_vitesse_glissement_brute.append(float(val))
            elif k == 8:
                l_deplacement_brute.append(float(val))
            else:
                l_pas_brute.append(float(val))
            k+=1
N_brute = len(l_temps_brute)

i, i_min, i_max = 0, 0, 0

while i_min == 0:
    if l_temps_brute[i] > t_i:
        i_min = i
    i+=1
while i_max == 0:
    if l_temps_brute[i] >= t_f:
        i_max = i
    i += 1

l_temps, l_vitesse_consigne, l_vitesse_moteur, l_vitesse_lineaire, l_courant, l_angle, l_vitesse_lineaire_calculee, l_vitesse_glissement, l_deplacement, l_pas = l_temps_brute[i_min:i_max], l_vitesse_consigne_brute[i_min:i_max], l_vitesse_moteur_brute[i_min:i_max], l_vitesse_lineaire_brute[i_min:i_max], l_courant_brute[i_min:i_max], l_angle_brute[i_min:i_max], l_vitesse_lineaire_calculee_brute[i_min:i_max], l_vitesse_glissement_brute[i_min:i_max], l_deplacement_brute[i_min:i_max], l_pas_brute[i_min:i_max]

N= len(l_temps)
#####################################
## FIN DE RECUPERATION DES DONNEES ##
#####################################

#courbe de vitesse
plt.figure("vitesse trancannage")
t=[Te*i for i in range(N)]
plt.plot(t,l_vitesse_moteur,"r",label="vitesse moteur")
plt.xlabel("temps (s)")
plt.ylabel("vitesse de rotation (tr/min)")
plt.legend()
plt.grid()
plt.show()

def deriv_kpas(L,Te,m):
    res=[]
    for i in range()):
        res.append(()
    return res

import matplotlib.pyplot as plt
def affichage(L,Te,titre_ordonnees):
    N=len(L)
    t=[Te*i for i in range(N)]
    plt.figure(titre_ordonnees)
    plt.plot(t,L)
    plt.xlabel("temps (s)")
    plt.ylabel(titre_ordonnees)
    plt.show()

for k in [] :
    l_vitesse_moteur_deriv=deriv_kpas(l_vitesse_moteur,Te,k)
    affichage(l_vitesse_moteur_deriv,Te,"accélération "+str(k)+" pas (tr/min/s)")

